/*
 * Decompiled with CFR 0.152.
 */
package de.fhwiesbaden.jgamp001.thello;

import de.fhwiesbaden.jgamp001.thello.PerfectInformationGame;
import de.fhwiesbaden.jgamp001.thello.RegularGame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRegularGame<M>
implements RegularGame<M>,
PerfectInformationGame<M>,
Cloneable {
    static final byte NONE = 0;
    static final byte ONE = 1;
    static final byte TWO = 22;
    byte player = 1;
    final byte rows;
    final byte columns;
    byte[][] b;
    public Integer movesDone = 0;
    byte lastColumn = (byte)-1;
    byte lastRow = (byte)-1;
    Boolean winsLast = null;

    @Override
    public byte getPlayerOne() {
        return 1;
    }

    @Override
    public byte getPlayerTwo() {
        return 22;
    }

    @Override
    public byte getPlayerNone() {
        return 0;
    }

    @Override
    public byte currentPlayer() {
        return this.player;
    }

    @Override
    public byte otherPlayer(byte p) {
        return p == 1 ? (byte)22 : 1;
    }

    public byte nextPlayer() {
        return this.otherPlayer(this.player);
    }

    public byte lastPlayer() {
        return this.otherPlayer(this.player);
    }

    @Override
    public int getRows() {
        return this.rows;
    }

    @Override
    public int getColumns() {
        return this.columns;
    }

    public AbstractRegularGame(byte c, byte r) {
        this.columns = c;
        this.rows = r;
        this.b = new byte[this.columns][];
        int i = 0;
        while (i < this.columns) {
            this.b[i] = new byte[this.rows];
            ++i;
        }
    }

    @Override
    public abstract Boolean isLegalMove(M var1);

    @Override
    public abstract AbstractRegularGame<M> setAtPosition(byte var1, byte var2);

    @Override
    public byte getAtPosition(byte column, byte row) {
        return this.b[column][row];
    }

    public boolean wins() {
        if (this.winsLast == null) {
            this.winsLast = this.wins(this.lastPlayer());
        }
        return this.winsLast;
    }

    @Override
    public boolean ended() {
        return this.noMoreMove() || this.wins();
    }

    public AbstractRegularGame<M> clone() {
        AbstractRegularGame result = null;
        try {
            result = (AbstractRegularGame)super.clone();
            result.b = (byte[][])this.b.clone();
            result.winsLast = null;
            int i = 0;
            while (i < result.b.length) {
                result.b[i] = (byte[])result.b[i].clone();
                ++i;
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return result;
    }
}

