/*
 * Decompiled with CFR 0.152.
 */
package de.fhwiesbaden.jgamp001.thello;

import de.fhwiesbaden.jgamp001.thello.NotationsPanel;
import de.fhwiesbaden.jgamp001.thello.ThelloControl;
import de.fhwiesbaden.jgamp001.thello.ThelloGame;
import de.fhwiesbaden.jgamp001.thello.ai.Computerspieler;
import de.fhwiesbaden.jgamp001.thello.ai.JanAlphaBetaGame;
import de.fhwiesbaden.jgamp001.thello.networking.Netzwerkspieler;
import de.flothow.jago.netobj.NetworkMove;
import de.flothow.jago.netobj.Spielertyp;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import name.panitz.ludens.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexibleThelloControl
extends ThelloControl<Pair<Byte, Byte>>
implements Observer {
    private static final long serialVersionUID = 1L;
    public Computerspieler aiPlayer;
    Netzwerkspieler netPlayer = null;
    final JLabel status = new JLabel("Status:");
    final JTextArea statusWert = new JTextArea("");
    public final NotationsPanel notation = new NotationsPanel();
    final JLabel labelLastMove = new JLabel("Letzter Zug:");
    final JTextArea areaLastMove = new JTextArea("---");
    Spielertyp ersterSpieler = Spielertyp.LokalerSpieler;
    Spielertyp zweiterSpieler = Spielertyp.LokalerAgent;
    private boolean startfreigabe = false;
    private Timer t;
    static int preferredKITiefe = 7;

    public FlexibleThelloControl() {
        this(new ThelloGame(), null, Spielertyp.LokalerSpieler, Spielertyp.LokalerAgent);
    }

    public FlexibleThelloControl(ThelloGame thello, Netzwerkspieler netPlayer, Spielertyp erster, Spielertyp zweiter) {
        super(thello);
        this.netPlayer = netPlayer;
        this.ersterSpieler = erster;
        this.zweiterSpieler = zweiter;
        this.remove(this.board);
        this.initLayout();
        this.repaint();
        this.aiPlayer = new Computerspieler(this, new JanAlphaBetaGame<Pair<Byte, Byte>>(preferredKITiefe));
        if (netPlayer != null) {
            this.netPlayer.addObserver(this);
        }
        this.aiPlayer.addObserver(this);
        this.initTimer();
    }

    @Override
    public void startFreigeben(boolean arg0) {
        this.startfreigabe = arg0;
        if (arg0) {
            this.t.start();
        } else {
            this.t.stop();
        }
    }

    private void initTimer() {
        this.t = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                FlexibleThelloControl.this.timerLookup();
            }
        });
    }

    private void initLayout() {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints constr = new GridBagConstraints();
        constr.fill = 1;
        constr.weightx = 10.0;
        constr.weighty = 10.0;
        this.areaLastMove.setEditable(false);
        this.statusWert.setEditable(false);
        this.statusWert.setPreferredSize(new Dimension(220, 10));
        this.insLayoutEinsetzen(0, 0, 5, 5, layout, constr, this.board);
        this.add(this.board);
        this.insLayoutEinsetzen(0, 7, 1, 1, layout, constr, this.status);
        this.add(this.status);
        this.insLayoutEinsetzen(1, 7, 1, 1, layout, constr, this.statusWert);
        this.add(this.statusWert);
        this.insLayoutEinsetzen(0, 9, 1, 1, layout, constr, this.labelLastMove);
        this.add(this.labelLastMove);
        this.insLayoutEinsetzen(1, 9, 1, 1, layout, constr, this.areaLastMove);
        this.add(this.areaLastMove);
        this.insLayoutEinsetzen(7, 0, 2, 5, layout, constr, this.notation);
        this.add(this.notation);
    }

    private void insLayoutEinsetzen(int x, int y, int width, int height, GridBagLayout layout, GridBagConstraints constr, Component dings) {
        constr.gridx = x;
        constr.gridy = y;
        constr.gridwidth = width;
        constr.gridheight = height;
        layout.setConstraints(dings, constr);
    }

    private void timerLookup() {
        if (this.board.getGame().noMoreMove()) {
            this.spielAbbrechen("Spielende. Spieler " + (this.board.getGame().wins(this.board.getGame().getPlayerOne()) ? "Eins" : (this.board.getGame().wins(this.board.getGame().getPlayerTwo()) ? "Zwei" : "niemand")) + " gewinnt");
            return;
        }
        if (this.istSpielerTypAmZug(Spielertyp.LokalerAgent)) {
            if (this.aiPlayer.denktGerade().booleanValue()) {
                this.statusWert.setText("Warte auf Computerspieler...");
            } else {
                this.aiPlayer.kiAnschubsen();
            }
        } else if (this.istEinFernerSpielerAmZug()) {
            this.statusWert.setText("Warte auf Netzwerkspieler...");
        } else if (this.istSpielerTypAmZug(Spielertyp.LokalerSpieler)) {
            this.statusWert.setText("Warte auf lokalen Spieler (" + (this.board.getGame().currentPlayer() == this.board.getGame().getPlayerOne() ? "Rot" : "Blau") + ")");
        }
    }

    @Override
    public void whenMousePressed(byte c, byte r) {
        if (this.board.getGame().ended()) {
            JOptionPane.showMessageDialog(this, "Spielende \n" + (this.board.getGame().wins(this.board.getGame().getPlayerOne()) ? "Rot" : (this.board.getGame().wins(this.board.getGame().getPlayerTwo()) ? "Blau" : "Niemand")) + " hat gewonnen!");
            return;
        }
        if (this.istSpielerTypAmZug(Spielertyp.LokalerSpieler) && this.startfreigabe) {
            this.macheSpielzug(c, r, true);
        }
    }

    private void macheSpielzug(NetworkMove move) {
        if (move.getMove().getSeqNr() == this.board.getGame().movesDone + 1) {
            this.macheSpielzug(move.getMove().getCol(), move.getMove().getRow(), false);
            if (move.getNextPlayer() != this.board.getGame().currentPlayer()) {
                this.spielAbbrechen("Illegalen Zug empfangen. nextPlayer() stimmen nicht ueberein \nMove meint: " + move.getNextPlayer() + " Ich meine: " + this.board.getGame().nextPlayer());
            }
        } else {
            this.spielAbbrechen("Illegalen Zug empfangen. Zugnummer inkorrekt");
        }
    }

    private void macheSpielzug(byte c, byte r, boolean weitersagen) {
        if (this.board.getGame().isLegalMove(new Pair<Byte, Byte>(c, r)).booleanValue()) {
            this.zugAufschreiben(c, r);
            this.board.setGame(this.board.getGame().setAtPosition(c, r));
            if (this.netPlayer != null && weitersagen) {
                this.zugWeitersagen(c, r);
            }
        } else {
            Spielertyp werwars = this.getCurrentPlayersSpielertyp();
            if (werwars.equals((Object)Spielertyp.LokalerSpieler)) {
                this.statusWert.setText("Illegaler Zug");
            } else if (werwars.equals((Object)Spielertyp.LokalerAgent)) {
                this.spielAbbrechen("Illegalen Zug von der lokalen KI empfangen. Bitte den Programmierer erschlagen");
            } else if (werwars.equals((Object)Spielertyp.FernerSpieler)) {
                this.spielAbbrechen("Illegalen Zug vom fernen Spieler empfangen. Spielende");
            } else if (werwars.equals((Object)Spielertyp.FernerAgent)) {
                this.spielAbbrechen("Illegalen Zug von ferner KI empfangen. Bitte den Programmierer erschlagen");
            }
        }
    }

    private void zugWeitersagen(Byte c, Byte r) {
        try {
            this.netPlayer.send(new NetworkMove(c, r, this.board.getGame().movesDone.byteValue(), this.board.getGame().currentPlayer()));
        }
        catch (IOException e) {
            this.spielAbbrechen("Verbindungsfehler, Spielabbruch: " + e.toString());
        }
    }

    private void zugAufschreiben(Byte c, Byte r) {
        String spielzug = "" + Character.forDigit(10 + c.intValue(), 36) + (r.intValue() + 1);
        this.areaLastMove.setText(spielzug);
        this.notation.aufschreiben(spielzug, this.board.getGame().currentPlayer() == this.board.getGame().getPlayerOne());
    }

    private boolean istEinFernerSpielerAmZug() {
        return this.istSpielerTypAmZug(Spielertyp.FernerAgent) || this.istSpielerTypAmZug(Spielertyp.FernerSpieler);
    }

    private boolean istEinLokalerSpielerAmZug() {
        return this.istSpielerTypAmZug(Spielertyp.LokalerAgent) || this.istSpielerTypAmZug(Spielertyp.LokalerSpieler);
    }

    private boolean istSpielerTypAmZug(Spielertyp arg0) {
        return this.getCurrentPlayersSpielertyp().equals((Object)arg0);
    }

    private Spielertyp getCurrentPlayersSpielertyp() {
        return this.board.getGame().currentPlayer() == this.board.getGame().getPlayerOne() ? this.ersterSpieler : this.zweiterSpieler;
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        this.statusWert.setText("Datenempfang");
        if (arg0 == this.netPlayer && arg1 instanceof NetworkMove && this.istEinFernerSpielerAmZug()) {
            this.macheSpielzug((NetworkMove)arg1);
            this.statusWert.setText("Netzwerkspieler hat gezogen");
        } else if (arg0 == this.aiPlayer && arg1 instanceof Pair && this.istSpielerTypAmZug(Spielertyp.LokalerAgent)) {
            Pair move = (Pair)arg1;
            this.macheSpielzug((Byte)move.fst, (Byte)move.snd, true);
            this.statusWert.setText("Computerspieler hat gezogen");
        } else if (arg0 == this.netPlayer && arg1.toString().equals("EndOfListening")) {
            this.spielAbbrechen("Verbindungsabbruch");
        } else {
            this.statusWert.setText("Unvorhergesehener Datenempfang");
        }
    }

    private void trenneNetzwerkverbindung() {
        if (this.netPlayer != null) {
            this.netPlayer.reset();
            this.netPlayer.deleteObservers();
        }
    }

    @Override
    public void spielAbbrechen(String string) {
        JOptionPane.showMessageDialog(this, "Spielende \n" + string);
        this.spielAbbrechen();
    }

    public void spielAbbrechen() {
        this.startFreigeben(false);
        this.aiPlayer.kiBeenden();
        this.trenneNetzwerkverbindung();
    }
}

