/*
 * Decompiled with CFR 0.152.
 */
package de.fhwiesbaden.jgamp001.thello;

import java.awt.Dimension;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class NotationsPanel
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    JTable notationsTabelle = null;
    final Vector<Vector<String>> spielerZuege = new Vector();
    final Vector<String> zeilenNamen = new Vector();
    final Vector<String> spielerEinsZuege = new Vector();
    final Vector<String> spielerZweiZuege = new Vector();
    Boolean zuletztEinsAufgeschrieben = false;

    public NotationsPanel() {
        this.initVector();
        this.initTable();
        this.add(this.notationsTabelle);
        this.setPreferredSize(new Dimension(250, 300));
        this.setViewportView(this.notationsTabelle);
    }

    public void aufschreiben(String zug, Boolean spielerEins) {
        if (this.zuletztEinsAufgeschrieben.booleanValue() && spielerEins.booleanValue() || !this.zuletztEinsAufgeschrieben.booleanValue() && !spielerEins.booleanValue()) {
            if (spielerEins.booleanValue()) {
                this.spielerZweiZuege.add("Null");
            } else {
                this.spielerEinsZuege.add("Null");
            }
        }
        if (spielerEins.booleanValue()) {
            this.spielerEinsZuege.add(zug);
        } else {
            this.spielerZweiZuege.add(zug);
        }
        this.zuletztEinsAufgeschrieben = spielerEins;
        this.repaint();
    }

    private void initVector() {
        this.zeilenNamen.add("Nr.");
        this.zeilenNamen.add("Rot");
        this.zeilenNamen.add("Blau");
        this.spielerZuege.add(this.spielerEinsZuege);
        this.spielerZuege.add(this.spielerZweiZuege);
    }

    private void initTable() {
        this.notationsTabelle = new JTable(new AbstractTableModel(){
            private static final long serialVersionUID = 1L;

            public int getColumnCount() {
                return 3;
            }

            public int getRowCount() {
                return 60;
            }

            public Object getValueAt(int arg0, int arg1) {
                if (arg1 == 0) {
                    return arg0 + 1;
                }
                if (arg1 == 1 && arg0 < NotationsPanel.this.spielerEinsZuege.size()) {
                    return NotationsPanel.this.spielerEinsZuege.get(arg0);
                }
                if (arg1 == 2 && arg0 < NotationsPanel.this.spielerZweiZuege.size()) {
                    return NotationsPanel.this.spielerZweiZuege.get(arg0);
                }
                return "-";
            }

            public String getColumnName(int column) {
                String result = "-";
                switch (column) {
                    case 0: {
                        result = "Nr.";
                        break;
                    }
                    case 1: {
                        result = "Rot";
                        break;
                    }
                    case 2: {
                        result = "Blau";
                        break;
                    }
                }
                return result;
            }
        });
    }

    public void notationSpeichern(File selectedFile) throws IOException {
        FileWriter schreiberling = null;
        schreiberling = new FileWriter(selectedFile);
        String newline = System.getProperty("line.separator");
        schreiberling.append("Thello Spielstand" + newline);
        Iterator<String> itEins = this.spielerEinsZuege.iterator();
        Iterator<String> itZwei = this.spielerZweiZuege.iterator();
        Integer zaehler = 0;
        while (itEins.hasNext()) {
            zaehler = zaehler + 1;
            schreiberling.append(zaehler + ". " + itEins.next() + " - " + (itZwei.hasNext() ? itZwei.next() : "") + newline);
        }
        schreiberling.close();
    }
}

