/*
 * Decompiled with CFR 0.152.
 */
package de.fhwiesbaden.jgamp001.thello;

import de.fhwiesbaden.jgamp001.thello.BenchmarkControl;
import de.fhwiesbaden.jgamp001.thello.FlexibleThelloControl;
import de.fhwiesbaden.jgamp001.thello.ThelloGame;
import de.fhwiesbaden.jgamp001.thello.networking.Netzwerkserver;
import de.fhwiesbaden.jgamp001.thello.networking.Netzwerkspieler;
import de.fhwiesbaden.jgamp001.thello.networking.gui.NeuesServerSpiel;
import de.fhwiesbaden.jgamp001.thello.networking.gui.SpielTeilnehmen;
import de.flothow.jago.netobj.Spielertyp;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class Spielfenster
extends JFrame {
    private static final long serialVersionUID = 1L;
    private FlexibleThelloControl spielFeld;
    private final Netzwerkserver functionalServer = Netzwerkserver.getServer();
    private final Netzwerkspieler functionalClient = Netzwerkspieler.getNetzwerkspieler();
    private JMenuItem spielNeuesSpiel;
    private JMenuItem spielNeuesNetzwerkSpiel;
    private JMenuItem spielNeuesSpielBeitritt;
    private JMenuItem spielSpielBeenden;
    private JMenuItem spielNotationSpeichern;
    private JMenuItem spielBeenden;
    private JMenuItem optionenSchwierigkeit;
    private JMenuItem optionenBenchmark;
    private JMenuItem hilfeAbout;
    private JMenu menuSpiel;
    private JMenu menuOptionen;
    private JMenu menuHilfe;
    private JMenuBar menuLeiste;

    public Spielfenster(FlexibleThelloControl control) throws HeadlessException {
        this.spielFeld = control;
        this.add(this.spielFeld);
        this.initMenus();
        this.pack();
        this.spielFeld.startFreigeben(true);
        this.setTitle("Thello - AlphaBeta 2.0");
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
    }

    private void initMenus() {
        this.menusBenennen();
        this.aktionenZuordnen();
        this.menuEinsetzen();
    }

    private void menusBenennen() {
        this.menuLeiste = new JMenuBar();
        this.menuSpiel = new JMenu("Spiel");
        this.menuOptionen = new JMenu("Optionen");
        this.menuHilfe = new JMenu("Hilfe");
        this.spielNeuesSpiel = new JMenuItem("Neues Spiel");
        this.spielNeuesNetzwerkSpiel = new JMenuItem("Neues Netzwerkspiel erstellen");
        this.spielNeuesSpielBeitritt = new JMenuItem("Einem Netzwerkspiel beitreten");
        this.spielSpielBeenden = new JMenuItem("Aktuelles Spiel beenden");
        this.spielNotationSpeichern = new JMenuItem("Spielverlauf abspeichern");
        this.spielBeenden = new JMenuItem("Beenden");
        this.optionenSchwierigkeit = new JMenuItem("Schwierigkeitsgrad einstellen");
        this.optionenBenchmark = new JMenuItem("Benchmark");
        this.hilfeAbout = new JMenuItem("Info");
    }

    private void aktionenZuordnen() {
        this.spielNeuesSpiel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                Spielfenster.this.pressedNeuesSpiel();
            }
        });
        this.spielNeuesNetzwerkSpiel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                Spielfenster.this.pressedNeuesNetzwerkSpiel();
            }
        });
        this.spielNeuesSpielBeitritt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                Spielfenster.this.pressedNeuesSpielBeitritt();
            }
        });
        this.spielSpielBeenden.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                Spielfenster.this.pressedAktuellesSpielBeenden();
            }
        });
        this.spielNotationSpeichern.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                Spielfenster.this.pressedSpielNotationSpeichern();
            }
        });
        this.spielBeenden.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                Spielfenster.this.pressedSpielBeenden();
            }
        });
        this.optionenSchwierigkeit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                Spielfenster.this.pressedOptionenSchwierigkeit();
            }
        });
        this.optionenBenchmark.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                Spielfenster.this.pressedOptionenBenchmark();
            }
        });
        this.hilfeAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                Spielfenster.this.pressedHilfeAbout();
            }
        });
    }

    private void menuEinsetzen() {
        this.menuSpiel.add(this.spielNeuesSpiel);
        this.menuSpiel.add(this.spielNeuesNetzwerkSpiel);
        this.menuSpiel.add(this.spielNeuesSpielBeitritt);
        this.menuSpiel.add(this.spielSpielBeenden);
        this.menuSpiel.addSeparator();
        this.menuSpiel.add(this.spielNotationSpeichern);
        this.menuSpiel.addSeparator();
        this.menuSpiel.add(this.spielBeenden);
        this.menuOptionen.add(this.optionenSchwierigkeit);
        this.menuOptionen.add(this.optionenBenchmark);
        this.menuHilfe.add(this.hilfeAbout);
        this.menuLeiste.add(this.menuSpiel);
        this.menuLeiste.add(this.menuOptionen);
        this.menuLeiste.add(this.menuHilfe);
        this.setJMenuBar(this.menuLeiste);
        this.menuLeiste.setVisible(true);
    }

    public void setThelloControl(FlexibleThelloControl dings) {
        if (this.spielFeld != null) {
            this.spielFeld.spielAbbrechen();
            this.remove(this.spielFeld);
        }
        this.spielFeld = dings;
        this.add(this.spielFeld);
        this.pack();
    }

    public FlexibleThelloControl getFlexibleThelloControl() {
        return this.spielFeld;
    }

    public void repaint() {
        super.repaint();
        this.spielFeld.repaint();
    }

    private void pressedNeuesSpiel() {
        if (this.sicherheitsAbfrage("Dies beendet das alte Spiel. Fortfahren?")) {
            this.aktuellesSpielBeenden();
            this.neuesSpiel();
        }
    }

    private void pressedNeuesNetzwerkSpiel() {
        if (this.sicherheitsAbfrage("Dies beendet das alte Spiel. Fortfahren?")) {
            this.aktuellesSpielBeenden();
            this.neuesNetzwerkSpiel();
        }
    }

    private void pressedNeuesSpielBeitritt() {
        if (this.sicherheitsAbfrage("Dies beendet das alte Spiel. Fortfahren?")) {
            this.aktuellesSpielBeenden();
            this.neuesSpielBeitritt();
        }
    }

    private void pressedAktuellesSpielBeenden() {
        this.aktuellesSpielBeenden();
    }

    private void pressedSpielNotationSpeichern() {
        JFileChooser sucher = new JFileChooser();
        if (sucher.showSaveDialog(this) == 0) {
            try {
                this.spielFeld.notation.notationSpeichern(sucher.getSelectedFile());
            }
            catch (IOException e) {
                JOptionPane.showInternalMessageDialog(this, "Schreiben fehlgeschlagen: " + e.toString());
            }
        }
    }

    private void pressedSpielBeenden() {
        this.spielBeenden();
    }

    private void pressedOptionenSchwierigkeit() {
        this.optionenSchwierigkeit();
    }

    private void pressedOptionenBenchmark() {
        this.optionenBenchmark();
    }

    private void pressedHilfeAbout() {
        this.hilfeAbout();
    }

    private boolean sicherheitsAbfrage(String text) {
        return JOptionPane.showConfirmDialog(this, text, "Hinweis", 0) == 0;
    }

    private void neuesSpiel() {
        Spielertyp zwei;
        Spielertyp eins;
        Object[] possibilities = new Object[]{"Spieler-Spieler", "Computer-Spieler", "Spieler-Computer", "Computer-Computer"};
        String s = (String)JOptionPane.showInputDialog(this, "Spielart waehlen:\n", "Neues Spiel", -1, null, possibilities, "Spieler-Spieler");
        if (s != null) {
            if (s.equals("Spieler-Spieler")) {
                eins = Spielertyp.LokalerSpieler;
                zwei = Spielertyp.LokalerSpieler;
            } else if (s.equals("Computer-Spieler")) {
                eins = Spielertyp.LokalerAgent;
                zwei = Spielertyp.LokalerSpieler;
            } else if (s.equals("Computer-Computer")) {
                eins = Spielertyp.LokalerAgent;
                zwei = Spielertyp.LokalerAgent;
            } else {
                eins = Spielertyp.LokalerSpieler;
                zwei = Spielertyp.LokalerAgent;
            }
        } else {
            return;
        }
        this.setThelloControl(new FlexibleThelloControl(new ThelloGame(), null, eins, zwei));
        this.getFlexibleThelloControl().startFreigeben(true);
        this.spielNotationSpeichern.setEnabled(true);
    }

    private void neuesNetzwerkSpiel() {
        NeuesServerSpiel dings = new NeuesServerSpiel(this);
        dings.setVisible(true);
        this.spielNotationSpeichern.setEnabled(true);
    }

    private void neuesSpielBeitritt() {
        SpielTeilnehmen dings = new SpielTeilnehmen(this);
        dings.setVisible(true);
        this.spielNotationSpeichern.setEnabled(true);
    }

    private void aktuellesSpielBeenden() {
        this.functionalClient.reset();
        if (Netzwerkserver.serverExists()) {
            try {
                this.functionalServer.closeServer();
            }
            catch (IOException e) {
                System.out.println("Fehler waehrend closeServer(): " + e.toString());
            }
        }
        this.getFlexibleThelloControl().spielAbbrechen();
        this.getFlexibleThelloControl().setVisible(false);
        this.spielNotationSpeichern.setEnabled(false);
    }

    private void spielBeenden() {
        this.setVisible(false);
        this.spielFeld.aiPlayer.kiBeenden();
        System.exit(0);
    }

    private void optionenSchwierigkeit() {
        Object[] possibilities = new Integer[]{1, 3, 5, 7, 9, 11};
        Integer s = (Integer)JOptionPane.showInputDialog(this, "Rekursionstiefe der KI waehlen (in Halbz\u00fcgen):\n", "Schwierigkeitsgrad", -1, null, possibilities, FlexibleThelloControl.preferredKITiefe);
        if (s != null) {
            FlexibleThelloControl.preferredKITiefe = s;
            if (this.spielFeld != null && this.spielFeld.aiPlayer != null) {
                this.spielFeld.aiPlayer.setDepth(s);
            }
        }
    }

    private void optionenBenchmark() {
        BenchmarkControl opt = new BenchmarkControl();
        opt.setVisible(true);
    }

    private void hilfeAbout() {
        String nl = System.getProperty("line.separator");
        JOptionPane.showMessageDialog(this, "Thello" + nl + "'Yet another othello clone'" + nl + "2007/2008 - Jan Gampe (Jan.Gampe@gmx.de)" + nl);
    }

    public static void main(String[] args) {
        Spielfenster neu = new Spielfenster(new FlexibleThelloControl());
        neu.setLocation(100, 100);
        neu.pack();
        neu.setVisible(true);
    }
}

