/*
 * Decompiled with CFR 0.152.
 */
package de.fhwiesbaden.jgamp001.thello;

import de.fhwiesbaden.jgamp001.thello.AbstractRegularGame;
import de.fhwiesbaden.jgamp001.thello.Board;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThelloBoard<M>
extends JPanel
implements Board<M> {
    private static final long serialVersionUID = 1L;
    private AbstractRegularGame<M> game;
    public int UNIT = 50;

    ThelloBoard(AbstractRegularGame<M> g) {
        this.game = g;
    }

    public void setGame(AbstractRegularGame<M> g) {
        this.game = g;
        this.repaint();
    }

    public AbstractRegularGame<M> getGame() {
        return this.game;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension((this.game.getColumns() + 1) * this.UNIT, (this.game.getRows() + 1) * this.UNIT);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintBackground(g);
        this.paintSpielsteine(g);
        this.paintHilfslinien(g);
        this.paintKoordinatensystem(g);
        this.paintSteinezahl(g);
    }

    private void paintBackground(Graphics g) {
        g.setColor(Color.lightGray);
        g.fillRect(0, 0, this.game.getRows() * this.UNIT, this.game.getColumns() * this.UNIT);
    }

    private void paintSpielsteine(Graphics g) {
        byte c = 0;
        while (c < this.game.getColumns()) {
            byte r = 0;
            while (r < this.game.getRows()) {
                if (this.game.getAtPosition(c, r) != this.game.getPlayerNone()) {
                    g.setColor(this.selectColor(this.game.getAtPosition(c, r)));
                    g.fillOval(c * this.UNIT + 2, r * this.UNIT + 2, this.UNIT - 4, this.UNIT - 4);
                    g.setColor(g.getColor().equals(Color.RED) ? Color.ORANGE : Color.cyan);
                    g.drawOval(c * this.UNIT + 8, r * this.UNIT + 8, this.UNIT - 16, this.UNIT - 16);
                    g.setColor(Color.black);
                    g.drawOval(c * this.UNIT + 2, r * this.UNIT + 2, this.UNIT - 4, this.UNIT - 4);
                }
                r = (byte)(r + 1);
            }
            c = (byte)(c + 1);
        }
    }

    private void paintHilfslinien(Graphics g) {
        g.setColor(Color.gray);
        int c = 0;
        while (c <= this.game.getColumns()) {
            g.drawLine(c * this.UNIT, 0, c * this.UNIT, this.game.getRows() * this.UNIT);
            c = (byte)(c + 1);
        }
        int r = 0;
        while (r <= this.game.getRows()) {
            g.drawLine(0, r * this.UNIT, this.game.getRows() * this.UNIT, r * this.UNIT);
            r = (byte)(r + 1);
        }
    }

    private void paintKoordinatensystem(Graphics g) {
        g.setColor(Color.BLACK);
        Character spaltenzeichen = Character.valueOf('A');
        int c = 0;
        while (c < this.game.getColumns()) {
            String zeichen = spaltenzeichen.toString();
            g.drawString(zeichen, c * this.UNIT + 40, 10);
            spaltenzeichen = Character.valueOf((char)(spaltenzeichen.charValue() + '\u0001'));
            c = (byte)(c + 1);
        }
        Character reihenzeichen = Character.valueOf('1');
        int c2 = 0;
        while (c2 < this.game.getColumns()) {
            String zeichen = reihenzeichen.toString();
            g.drawString(zeichen, 0, c2 * this.UNIT + 49);
            reihenzeichen = Character.valueOf((char)(reihenzeichen.charValue() + '\u0001'));
            c2 = (byte)(c2 + 1);
        }
    }

    private void paintSteinezahl(Graphics g) {
        g.setColor(this.selectColor(this.game.getPlayerOne()));
        g.fillOval(1 * this.UNIT + 2, this.game.getRows() * this.UNIT + 2, this.UNIT - 4, this.UNIT - 4);
        g.setColor(g.getColor().equals(Color.RED) ? Color.ORANGE : Color.cyan);
        g.drawOval(1 * this.UNIT + 8, this.game.getRows() * this.UNIT + 8, this.UNIT - 16, this.UNIT - 16);
        g.setColor(Color.black);
        g.drawOval(1 * this.UNIT + 2, this.game.getRows() * this.UNIT + 2, this.UNIT - 4, this.UNIT - 4);
        g.setColor(this.selectColor(this.game.getPlayerTwo()));
        g.fillOval((this.game.getColumns() - 1) * this.UNIT + 2, this.game.getRows() * this.UNIT + 2, this.UNIT - 4, this.UNIT - 4);
        g.setColor(g.getColor().equals(Color.RED) ? Color.ORANGE : Color.cyan);
        g.drawOval((this.game.getColumns() - 1) * this.UNIT + 8, this.game.getRows() * this.UNIT + 8, this.UNIT - 16, this.UNIT - 16);
        g.setColor(Color.black);
        g.drawOval((this.game.getColumns() - 1) * this.UNIT + 2, this.game.getRows() * this.UNIT + 2, this.UNIT - 4, this.UNIT - 4);
        g.drawString(String.valueOf(this.getGame().getSteineEins().toString()) + "x", 18, this.game.getRows() * this.UNIT + 30);
        g.drawString(String.valueOf(this.getGame().getSteineZwei().toString()) + "x", 18 + (this.game.getColumns() - 2) * this.UNIT, this.game.getRows() * this.UNIT + 30);
    }

    Color selectColor(byte player) {
        if (player == this.game.getPlayerOne()) {
            return Color.RED;
        }
        if (player == this.game.getPlayerTwo()) {
            return Color.BLUE;
        }
        return Color.BLACK;
    }
}

