/*
 * Decompiled with CFR 0.152.
 */
package de.fhwiesbaden.jgamp001.thello;

import de.fhwiesbaden.jgamp001.thello.AbstractRegularGame;
import de.fhwiesbaden.jgamp001.thello.Data;
import java.util.LinkedList;
import java.util.List;
import name.panitz.ludens.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThelloGame
extends AbstractRegularGame<Pair<Byte, Byte>> {
    static Data werte = new Data();
    Integer steineEins = 2;
    Integer steineZwei = 2;
    List<Pair<Byte, Byte>> currentPlayersMoves = null;
    List<Pair<Byte, Byte>> opponentMoves = null;

    @Override
    public Integer getSteineEins() {
        return this.steineEins;
    }

    @Override
    public Integer getSteineZwei() {
        return this.steineZwei;
    }

    public ThelloGame() {
        super((byte)8, (byte)8);
        this.b[3][3] = 22;
        this.b[4][4] = 22;
        this.b[3][4] = 1;
        this.b[4][3] = 1;
    }

    @Override
    public ThelloGame clone() {
        return (ThelloGame)super.clone();
    }

    @Override
    public ThelloGame setAtPosition(byte column, byte row) {
        return this.doMove(new Pair<Byte, Byte>(column, row));
    }

    public ThelloGame doMove(Pair<Byte, Byte> m) {
        ThelloGame result = this.clone();
        result.currentPlayersMoves = null;
        result.opponentMoves = null;
        if (result.steineSetzen(m, result.player)) {
            result.player = result.nextPlayer();
            result.movesDone = result.movesDone + 1;
            result.steineEins = result.steineZaehlen(ThelloGame.werte.alleFelder, this.getPlayerOne());
            result.steineZwei = result.steineZaehlen(ThelloGame.werte.alleFelder, this.getPlayerTwo());
        } else {
            result = this;
        }
        return result;
    }

    private boolean steineSetzen(Pair<Byte, Byte> m, byte spieler) {
        boolean result = false;
        Pair<Integer, Integer> ko = new Pair<Integer, Integer>(((Byte)m.fst).intValue(), ((Byte)m.snd).intValue());
        List<Pair<Pair<Integer, Integer>, Integer>> arbeit = this.feldSchliesstGegnerEin((Integer)ko.fst, (Integer)ko.snd, spieler);
        for (Pair<Pair<Integer, Integer>, Integer> elem : arbeit) {
            this.steineDrehen((Integer)ko.fst, (Integer)ko.snd, (Pair)elem.fst, (Integer)elem.snd);
            result = true;
        }
        return result;
    }

    private void steineDrehen(int fst, int snd, Pair<Integer, Integer> richtung, int i) {
        int j = 0;
        while (j <= i) {
            this.b[fst + ((Integer)richtung.fst).intValue() * j][snd + ((Integer)richtung.snd).intValue() * j] = this.player;
            ++j;
        }
    }

    private boolean istInnerhalbSpielfeld(int xKoord, int yKoord) {
        if (xKoord >= this.rows || xKoord < 0) {
            return false;
        }
        return yKoord < this.columns && yKoord >= 0;
    }

    @Override
    public byte nextPlayer() {
        if (this.getMovesOpponent().isEmpty() && this.getMovesCurrent().isEmpty()) {
            return this.getPlayerNone();
        }
        if (this.getMovesOpponent().isEmpty()) {
            return this.currentPlayer();
        }
        return this.otherPlayer(this.player);
    }

    @Override
    public int evalState(byte player) {
        if (this.wins(this.currentPlayer())) {
            return 999999;
        }
        if (this.wins(this.otherPlayer(player))) {
            return -999999;
        }
        int numPossibleMoves = this.moves().size();
        int spielphase = this.movesDone < 5 ? 0 : (this.movesDone < 20 ? 1 : (this.movesDone < 40 ? 2 : (this.movesDone < 50 ? 3 : 4)));
        Integer currentMobility = this.evalCurrentMobility(numPossibleMoves, spielphase);
        Integer potentialMobility = this.evalPotentialMobility(spielphase);
        Integer patternEvaluation = this.evalByPattern(spielphase);
        Integer schlechteZuege = 0;
        Integer guteZuege = 0;
        if (this.b[0][0] == this.getPlayerNone()) {
            schlechteZuege = schlechteZuege - 100 * this.steineZaehlen(ThelloGame.werte.schlechteFelderOL, this.currentPlayer());
            schlechteZuege = schlechteZuege - 60 * this.steineZaehlen(ThelloGame.werte.minderGuteFelderOL, this.currentPlayer());
        } else if (this.b[0][7] == this.getPlayerNone()) {
            schlechteZuege = schlechteZuege - 100 * this.steineZaehlen(ThelloGame.werte.schlechteFelderUL, this.currentPlayer());
            schlechteZuege = schlechteZuege - 60 * this.steineZaehlen(ThelloGame.werte.minderGuteFelderUL, this.currentPlayer());
        }
        if (this.b[7][7] == this.getPlayerNone()) {
            schlechteZuege = schlechteZuege - 100 * this.steineZaehlen(ThelloGame.werte.schlechteFelderUR, this.currentPlayer());
            schlechteZuege = schlechteZuege - 60 * this.steineZaehlen(ThelloGame.werte.minderGuteFelderUR, this.currentPlayer());
        }
        if (this.b[7][0] == this.getPlayerNone()) {
            schlechteZuege = schlechteZuege - 100 * this.steineZaehlen(ThelloGame.werte.schlechteFelderOR, this.currentPlayer());
            schlechteZuege = schlechteZuege - 60 * this.steineZaehlen(ThelloGame.werte.minderGuteFelderOR, this.currentPlayer());
        }
        schlechteZuege = schlechteZuege - 400 * this.steineZaehlen(ThelloGame.werte.eckpunkte, this.otherPlayer(this.currentPlayer()));
        guteZuege = guteZuege + 400 * this.steineZaehlen(ThelloGame.werte.eckpunkte, this.currentPlayer());
        guteZuege = guteZuege + 30 * this.steineZaehlen(ThelloGame.werte.restRandFelder, this.currentPlayer());
        return schlechteZuege + guteZuege + currentMobility * 2 + potentialMobility + patternEvaluation * 3;
    }

    private Integer evalCurrentMobility(int possibleMoves, int spielphase) {
        Integer result = 0;
        switch (spielphase) {
            case 0: {
                result = possibleMoves < 1 ? -128 : (possibleMoves < 4 ? -4 : (possibleMoves < 5 ? 0 : possibleMoves % 10));
                break;
            }
            case 1: {
                result = possibleMoves < 1 ? -128 : (possibleMoves < 4 ? -10 + possibleMoves * 2 : (possibleMoves < 6 ? 0 : possibleMoves % 10));
                break;
            }
            case 2: {
                result = possibleMoves < 1 ? -128 : (possibleMoves < 4 ? -20 + possibleMoves * 2 : (possibleMoves < 6 ? 0 : possibleMoves % 20));
                break;
            }
            case 3: {
                result = possibleMoves < 1 ? -128 : (possibleMoves < 4 ? -10 + possibleMoves * 2 : (possibleMoves < 6 ? 0 : possibleMoves % 10));
                break;
            }
            case 4: {
                result = possibleMoves;
                break;
            }
        }
        return result;
    }

    private int evalPotentialMobility(int spielphase) {
        int potMove = this.getPotentialMoves();
        int result = 0;
        switch (spielphase) {
            case 0: {
                result = potMove < 2 ? -20 : (potMove < 6 ? -20 + potMove * 3 : (potMove < 8 ? 5 : potMove));
                break;
            }
            case 1: {
                result = potMove < 3 ? -30 : (potMove < 7 ? -20 + potMove * 2 : (potMove < 10 ? potMove : potMove * 2));
                break;
            }
            case 2: {
                result = potMove < 4 ? -40 : (potMove < 8 ? -30 + potMove : (potMove < 10 ? potMove : potMove * 2));
                break;
            }
            case 3: {
                result = potMove < 3 ? -30 : (potMove < 7 ? -20 + potMove * 2 : (potMove < 10 ? potMove : potMove * 2));
                break;
            }
            case 4: {
                result = 5;
            }
        }
        return result;
    }

    private int getPotentialMoves() {
        int result = 0;
        int x = 0;
        while (x < 8) {
            int y = 0;
            while (y < 8) {
                if (this.b[x][y] == this.getPlayerNone() && this.istFeldNachbarVon(x, y, this.otherPlayer(this.currentPlayer())).booleanValue()) {
                    ++result;
                }
                ++y;
            }
            ++x;
        }
        return result;
    }

    private int evalByPattern(int spielphase) {
        int result = 0;
        result += this.countStabileSteine();
        if (spielphase == 4) {
            result = 15 * (this.getCurrentPlayersNumberOfStones() - this.getOpponentsNumberOfStones());
        }
        return result;
    }

    private int countStabileSteine() {
        int result = 0;
        result += this.countStabileEcksteine();
        return result += this.countStabileRandsteine();
    }

    private int countStabileRandsteine() {
        int result = 0;
        result += this.horizontalundvertikalPruefen(new Pair<Integer, Integer>(0, 0), new Pair<Integer, Integer>(1, 1));
        result += this.horizontalundvertikalPruefen(new Pair<Integer, Integer>(7, 7), new Pair<Integer, Integer>(-1, -1));
        result += this.horizontalundvertikalPruefen(new Pair<Integer, Integer>(0, 7), new Pair<Integer, Integer>(1, -1));
        return result += this.horizontalundvertikalPruefen(new Pair<Integer, Integer>(7, 0), new Pair<Integer, Integer>(-1, 1));
    }

    private int horizontalundvertikalPruefen(Pair<Integer, Integer> ecke, Pair<Integer, Integer> vektor) {
        int result = 0;
        int i = 0;
        while (i < 8) {
            if (this.b[(Integer)ecke.fst + (Integer)vektor.fst * i][(Integer)ecke.snd] != this.currentPlayer()) {
                result += i - 1;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < 8) {
            if (this.b[(Integer)ecke.fst][(Integer)ecke.snd + (Integer)vektor.snd * i] != this.currentPlayer()) {
                result += i - 1;
                break;
            }
            ++i;
        }
        return result;
    }

    private int countStabileEcksteine() {
        int result = 0;
        result += this.diagonalePruefen(new Pair<Integer, Integer>(0, 0), new Pair<Integer, Integer>(1, 1)).intValue();
        result += this.diagonalePruefen(new Pair<Integer, Integer>(7, 7), new Pair<Integer, Integer>(-1, -1)).intValue();
        result += this.diagonalePruefen(new Pair<Integer, Integer>(0, 7), new Pair<Integer, Integer>(1, -1)).intValue();
        return result += this.diagonalePruefen(new Pair<Integer, Integer>(7, 0), new Pair<Integer, Integer>(-1, 1)).intValue();
    }

    private Integer diagonalePruefen(Pair<Integer, Integer> ecke, Pair<Integer, Integer> vektor) {
        Integer result = 0;
        int i = 0;
        while (i < 8) {
            if (!this.diagonalePruefen(ecke, vektor, i)) {
                return result;
            }
            result = result + (i - 1);
            ++i;
        }
        return result;
    }

    private boolean diagonalePruefen(Pair<Integer, Integer> ecke, Pair<Integer, Integer> vektor, Integer laenge) {
        int i = 0;
        while (i <= laenge) {
            if (this.b[(Integer)ecke.fst + (Integer)vektor.fst * (laenge - i)][(Integer)ecke.snd + (Integer)vektor.snd * i] != this.currentPlayer()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Boolean istFeldNachbarVon(int x, int y, byte player) {
        for (Pair<Integer, Integer> richt : ThelloGame.werte.richtungen) {
            if (!this.istInnerhalbSpielfeld(x + (Integer)richt.fst, y + (Integer)richt.snd) || this.b[x + (Integer)richt.fst][y + (Integer)richt.snd] != player) continue;
            return true;
        }
        return false;
    }

    public int steineZaehlen(List<Pair<Integer, Integer>> liste, byte player) {
        int result = 0;
        for (Pair<Integer, Integer> element : liste) {
            if (this.b[(Integer)element.fst][(Integer)element.snd] != player) continue;
            ++result;
        }
        return result;
    }

    @Override
    public List<Pair<Byte, Byte>> moves() {
        return this.getMovesCurrent();
    }

    public List<Pair<Byte, Byte>> getMovesCurrent() {
        if (this.currentPlayersMoves == null) {
            this.currentPlayersMoves = this.moves(this.currentPlayer());
        }
        return this.currentPlayersMoves;
    }

    public List<Pair<Byte, Byte>> getMovesOpponent() {
        if (this.opponentMoves == null) {
            this.opponentMoves = this.moves(this.otherPlayer(this.currentPlayer()));
        }
        return this.opponentMoves;
    }

    public List<Pair<Byte, Byte>> moves(byte spieler) {
        LinkedList<Pair<Byte, Byte>> result = new LinkedList<Pair<Byte, Byte>>();
        Integer x = 0;
        while (x < this.rows) {
            Integer y = 0;
            while (y < this.columns) {
                if (!this.feldSchliesstGegnerEin(x, y, spieler).isEmpty()) {
                    result.add(new Pair<Byte, Byte>(x.byteValue(), y.byteValue()));
                }
                y = y + 1;
            }
            x = x + 1;
        }
        return result;
    }

    public List<Pair<Pair<Integer, Integer>, Integer>> feldSchliesstGegnerEin(int x, int y, byte spieler) {
        LinkedList<Pair<Pair<Integer, Integer>, Integer>> result = new LinkedList<Pair<Pair<Integer, Integer>, Integer>>();
        if (this.istInnerhalbSpielfeld(x, y) && this.b[x][y] == 0) {
            block0: for (Pair<Integer, Integer> richt : ThelloGame.werte.richtungen) {
                if (!this.istInnerhalbSpielfeld(x + (Integer)richt.fst, y + (Integer)richt.snd) || this.b[x + (Integer)richt.fst][y + (Integer)richt.snd] != this.otherPlayer(spieler)) continue;
                int i = 2;
                while (this.istInnerhalbSpielfeld(x + (Integer)richt.fst * i, y + (Integer)richt.snd * i)) {
                    if (this.b[x + (Integer)richt.fst * i][y + (Integer)richt.snd * i] == 0) continue block0;
                    if (this.b[x + (Integer)richt.fst * i][y + (Integer)richt.snd * i] == spieler) {
                        result.add(new Pair<Pair<Integer, Integer>, Integer>(richt, i));
                        continue block0;
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    @Override
    public boolean noMoreMove() {
        return this.movesDone >= 64 || this.getMovesOpponent().isEmpty() && this.getMovesCurrent().isEmpty() || this.zaehleSteine((byte)1) == 0 || this.zaehleSteine((byte)1) == 0;
    }

    @Override
    public boolean wins(byte player) {
        return this.noMoreMove() && this.zaehleSteine(player) > this.zaehleSteine(this.otherPlayer(player));
    }

    private int zaehleSteine(byte player) {
        int result = 0;
        Integer x = 0;
        while (x < this.rows) {
            Integer y = 0;
            while (y < this.columns) {
                if (this.b[x][y] == player) {
                    ++result;
                }
                y = y + 1;
            }
            x = x + 1;
        }
        return result;
    }

    @Override
    public Boolean isLegalMove(Pair<Byte, Byte> move) {
        List<Pair<Pair<Integer, Integer>, Integer>> einschluesse = this.feldSchliesstGegnerEin(((Byte)move.fst).intValue(), ((Byte)move.snd).intValue(), this.currentPlayer());
        return !einschluesse.isEmpty();
    }

    public String toString() {
        String result = "";
        result = String.valueOf(result) + "Zu ziehender Spieler:" + this.player + "\n";
        int y = 0;
        while (y < 8) {
            result = String.valueOf(result) + "I----" + (this.b[0][y] == 0 ? 0 : (this.b[0][y] == 1 ? 1 : 2)) + "----I----" + (this.b[1][y] == 0 ? 0 : (this.b[1][y] == 1 ? 1 : 2)) + "----I----" + (this.b[2][y] == 0 ? 0 : (this.b[2][y] == 1 ? 1 : 2)) + "----I----" + (this.b[3][y] == 0 ? 0 : (this.b[3][y] == 1 ? 1 : 2)) + "----I----" + (this.b[4][y] == 0 ? 0 : (this.b[4][y] == 1 ? 1 : 2)) + "----I----" + (this.b[5][y] == 0 ? 0 : (this.b[5][y] == 1 ? 1 : 2)) + "----I----" + (this.b[6][y] == 0 ? 0 : (this.b[6][y] == 1 ? 1 : 2)) + "----I----" + (this.b[7][y] == 0 ? 0 : (this.b[7][y] == 1 ? 1 : 2)) + "----I" + "\n";
            ++y;
        }
        return result;
    }

    @Override
    public Integer getMovesDone() {
        return this.movesDone;
    }

    public Integer getCurrentPlayersNumberOfStones() {
        if (this.currentPlayer() == 1) {
            return this.steineEins;
        }
        return this.steineZwei;
    }

    public Integer getOpponentsNumberOfStones() {
        if (this.otherPlayer(this.currentPlayer()) == 1) {
            return this.steineEins;
        }
        return this.steineZwei;
    }
}

