/*
 * Decompiled with CFR 0.152.
 */
package de.fhwiesbaden.jgamp001.thello.ai;

import de.fhwiesbaden.jgamp001.thello.FlexibleThelloControl;
import de.fhwiesbaden.jgamp001.thello.ai.JanAlphaBetaGame;
import java.util.Observable;
import java.util.concurrent.Semaphore;
import name.panitz.ludens.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Computerspieler
extends Observable
implements Runnable {
    private FlexibleThelloControl console = null;
    public JanAlphaBetaGame<Pair<Byte, Byte>> ai = null;
    private Semaphore sema = new Semaphore(1);

    public Computerspieler(FlexibleThelloControl console, JanAlphaBetaGame<Pair<Byte, Byte>> ai) {
        this.console = console;
        this.ai = ai;
    }

    public Boolean denktGerade() {
        if (this.sema.availablePermits() == 0) {
            return true;
        }
        return false;
    }

    public void kiAnschubsen() {
        Thread t = new Thread(this);
        t.start();
    }

    public void kiBeenden() {
        if (this.ai != null) {
            this.ai.forceQuit();
            this.ai = null;
        }
        if (this.console != null) {
            this.console = null;
        }
    }

    public Integer getDepth() {
        if (this.ai == null) {
            return 6;
        }
        return this.ai.getDepth();
    }

    public void setDepth(Integer depth) {
        try {
            this.sema.acquire(1);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
        if (this.ai != null) {
            this.ai.setDepth(depth);
        }
        this.sema.release(1);
    }

    @Override
    public void run() {
        if (this.sema.tryAcquire(1)) {
            Pair<Byte, Byte> move = this.ai.bestMove(this.console.board.getGame(), this.ai.getDepth());
            if (move != null) {
                this.setChanged();
                this.notifyObservers(move);
            }
            this.sema.release(1);
        }
    }
}

