/*
 * Decompiled with CFR 0.152.
 */
package de.fhwiesbaden.jgamp001.thello.ai;

import de.fhwiesbaden.jgamp001.thello.Game;
import de.fhwiesbaden.jgamp001.thello.ai.GameAI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinMaxGame<M>
implements GameAI<M> {
    int getDepth() {
        return 6;
    }

    int evalNextState(Game<M> g, byte player, int depth) {
        return this.minmax(g, player, depth);
    }

    int minmax(Game<M> g, byte player, int depth) {
        if (depth == 0 || g.ended()) {
            return g.evalState(player);
        }
        boolean isMax = g.currentPlayer() == player;
        int resultVal = isMax ? -2147483647 : Integer.MAX_VALUE;
        for (M m : g.moves()) {
            Game<M> child = g.doMove(m);
            int nextVal = this.minmax(child, player, depth - 1);
            if ((!isMax || nextVal < resultVal) && (isMax || nextVal > resultVal)) continue;
            resultVal = nextVal;
        }
        return resultVal;
    }

    @Override
    public Game<M> doBestMove(Game<M> g) {
        return g.doMove(this.bestMove(g));
    }

    @Override
    public M bestMove(Game<M> g) {
        return this.bestMove(g, this.getDepth());
    }

    public M bestMove(Game<M> g, int depth) {
        byte player = g.currentPlayer();
        int val = Integer.MIN_VALUE;
        M result = null;
        for (M m : g.moves()) {
            Game<M> s = g.doMove(m);
            int eval = this.evalNextState(s, player, depth - 1);
            if (eval <= val) continue;
            val = eval;
            result = m;
        }
        return result;
    }
}

