/*
 * Decompiled with CFR 0.152.
 */
package de.fhwiesbaden.jgamp001.thello.networking;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Observable;

public class Netzwerkserver
extends Observable
implements Runnable {
    private ServerSocket server = null;
    private Socket gensocket = null;
    private Thread t;
    private boolean serverInitialized = false;
    private boolean clientFound = false;
    private static Netzwerkserver internthis = null;

    public boolean isServerInitialized() {
        return this.serverInitialized;
    }

    public boolean isClientFound() {
        return this.clientFound;
    }

    public Socket getClientSocket() {
        return this.gensocket;
    }

    public ServerSocket getServerSocket() {
        return this.server;
    }

    private Netzwerkserver() {
    }

    public static Netzwerkserver getServer() {
        if (internthis == null) {
            internthis = new Netzwerkserver();
        }
        return internthis;
    }

    public static boolean serverExists() {
        return internthis != null;
    }

    public void initServer(Integer portnummer, Integer timeout) throws IOException, Exception {
        if (this.serverInitialized) {
            throw new IOException("Server bereits gestartet");
        }
        this.server = new ServerSocket(portnummer);
        this.server.setSoTimeout(timeout);
        this.serverInitialized = true;
    }

    public void listenForClient() throws Exception {
        if (!this.serverInitialized) {
            throw new Exception("Already Listening");
        }
        this.t = new Thread(this);
        this.t.start();
    }

    public void run() {
        try {
            this.gensocket = this.server.accept();
            this.clientFound = true;
            this.setChanged();
            this.notifyObservers(this.gensocket);
            return;
        }
        catch (Exception e) {
            this.setChanged();
            this.notifyObservers(e);
            return;
        }
    }

    public void closeServer() throws IOException {
        if (this.server != null) {
            this.server.close();
        }
        this.deleteObservers();
        this.gensocket = null;
        this.clientFound = false;
        this.serverInitialized = false;
    }

    public String toString() {
        String result = "Serverstatus: \n";
        if (this.server != null) {
            result = String.valueOf(result) + "Server ist nicht mehr null \n";
            result = this.server.isClosed() ? String.valueOf(result) + "Server ist geschlossen \n" : String.valueOf(result) + "Server ist offen \n";
        } else {
            result = String.valueOf(result) + "Server ist genullt";
        }
        result = this.gensocket != null ? String.valueOf(result) + "Gensocket ist nicht mehr null \n" : String.valueOf(result) + "Gensocket ist null \n";
        return result;
    }
}

