/*
 * Decompiled with CFR 0.152.
 */
package de.fhwiesbaden.jgamp001.thello.networking;

import de.flothow.jago.netobj.NetworkMove;
import de.flothow.jago.netobj.SpielInformation;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Observable;

public class Netzwerkspieler
extends Observable
implements Runnable {
    public Socket socke = null;
    private ObjectOutputStream eingabe = null;
    private ObjectInputStream ausgabe = null;
    private boolean erwarteEmpfang = false;
    private NetworkMove lastReceivedMove = null;
    private SpielInformation lastReceivedInfo = null;
    private Boolean lastReceivedBoolean = null;
    public Thread t = null;
    private boolean listening = false;
    private boolean socketSet = false;
    private boolean streamsSet = false;
    private static Netzwerkspieler internthis = null;

    private Netzwerkspieler() {
    }

    public static Netzwerkspieler getNetzwerkspieler() {
        if (internthis == null) {
            internthis = new Netzwerkspieler();
        }
        return internthis;
    }

    public NetworkMove getLastReceivedMove() {
        return this.lastReceivedMove;
    }

    public SpielInformation getLastReceivedInfo() {
        return this.lastReceivedInfo;
    }

    public Boolean getLastReceivedBoolean() {
        return this.lastReceivedBoolean;
    }

    public void setSocket(Socket socke) {
        this.socke = socke;
        this.SocketSetzen();
    }

    public void setSocket(String ipAdress, Integer port) throws UnknownHostException, IOException {
        this.socke = new Socket();
        this.socke.connect(new InetSocketAddress(ipAdress, (int)port), 10000);
        this.SocketSetzen();
    }

    private void SocketSetzen() {
        this.socketSet = true;
        try {
            this.socke.setReuseAddress(true);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
    }

    public void unsetSocket() throws IOException {
        if (this.socke != null) {
            this.socke.close();
        }
        this.socketSet = false;
    }

    public void setStreams() throws IOException {
        this.eingabe = new ObjectOutputStream(this.socke.getOutputStream());
        this.ausgabe = new ObjectInputStream(this.socke.getInputStream());
        this.streamsSet = true;
        this.erwarteEmpfang = true;
    }

    public void unsetStreams() throws IOException {
        if (this.eingabe != null) {
            this.eingabe.close();
        }
        if (this.ausgabe != null) {
            this.ausgabe.close();
        }
        this.streamsSet = false;
    }

    public void deinitListener() {
        this.listening = false;
        this.erwarteEmpfang = false;
    }

    public void reset() {
        try {
            if (this.streamsSet) {
                this.eingabe.close();
            }
            if (this.streamsSet) {
                this.ausgabe.close();
            }
            if (this.socketSet) {
                this.socke.close();
            }
        }
        catch (Exception e) {
            System.out.println("Fehler waehrend Reset: " + e.toString());
        }
        this.erwarteEmpfang = false;
        this.listening = false;
        this.socketSet = false;
        this.streamsSet = false;
        this.lastReceivedInfo = null;
        this.lastReceivedMove = null;
        this.eingabe = null;
        this.ausgabe = null;
        this.socke = null;
        this.deleteObservers();
    }

    public void initListener() throws Exception {
        if (!this.listening && this.socketSet && this.streamsSet) {
            this.t = new Thread(this);
            this.listening = true;
            this.t.start();
        } else {
            if (this.listening) {
                throw new Exception("Already listening");
            }
            if (!this.socketSet) {
                throw new Exception("Socket nicht initialisiert");
            }
            if (!this.streamsSet) {
                throw new Exception("Streams nicht initialisiert");
            }
        }
    }

    public void run() {
        Object eingang = null;
        while (this.erwarteEmpfang) {
            try {
                eingang = this.ausgabe.readObject();
            }
            catch (EOFException e) {
                this.listening = false;
                this.erwarteEmpfang = false;
                break;
            }
            catch (Exception e) {
                System.out.println("Ausnahme waehrend Empfang: " + e);
                this.listening = false;
                this.erwarteEmpfang = false;
                break;
            }
            this.dateneingangsBehandlung(eingang);
        }
        this.setChanged();
        this.notifyObservers("EndOfListening");
        System.out.println("Empfang beendet");
    }

    private void dateneingangsBehandlung(Object eingang) {
        if (eingang instanceof NetworkMove) {
            this.lastReceivedMove = (NetworkMove)eingang;
            this.setChanged();
            this.notifyObservers((NetworkMove)eingang);
        } else if (eingang instanceof SpielInformation) {
            this.lastReceivedInfo = (SpielInformation)eingang;
            this.setChanged();
            this.notifyObservers((SpielInformation)eingang);
        } else if (eingang instanceof Boolean) {
            this.setChanged();
            this.notifyObservers((Boolean)eingang);
        }
    }

    public boolean send(NetworkMove payload) throws IOException {
        return this.sendObject(payload);
    }

    public boolean send(SpielInformation payload) throws IOException {
        return this.sendObject(payload);
    }

    public boolean send(Boolean payload) throws IOException {
        return this.sendObject(payload);
    }

    private boolean sendObject(Object payload) throws IOException {
        if (this.streamsSet && this.socketSet) {
            this.eingabe.writeObject(payload);
            this.eingabe.flush();
            this.lastReceivedMove = null;
            return true;
        }
        throw new IOException("Socket/Streams nicht initialisiert.");
    }

    public String toString() {
        String result = "--------- Ueber Netzwerkspieler: ----------\n";
        if (this.socke != null) {
            result = String.valueOf(result) + "Socket ist nicht null \n";
            result = this.socke.isClosed() ? String.valueOf(result) + "Socket ist geschlossen \n" : String.valueOf(result) + "Socket ist offen \n";
        } else {
            result = String.valueOf(result) + "Socket ist null \n";
        }
        if (this.eingabe != null) {
            result = String.valueOf(result) + "OOS ist nicht null \n";
            result = String.valueOf(result) + this.eingabe.toString();
        } else {
            result = String.valueOf(result) + "OOS ist null \n";
        }
        if (this.ausgabe != null) {
            result = String.valueOf(result) + "OIS ist nicht null \n";
            result = String.valueOf(result) + this.ausgabe.toString();
        } else {
            result = String.valueOf(result) + "OIS ist null \n";
        }
        return String.valueOf(result) + "\n ------------------------- \n";
    }

    public ObjectInputStream getOIS() {
        return this.ausgabe;
    }

    public ObjectOutputStream getOOS() {
        return this.eingabe;
    }

    public Socket getSocket() {
        return this.socke;
    }
}

