/*
 * Decompiled with CFR 0.152.
 */
package de.fhwiesbaden.jgamp001.thello.networking.gui;

import de.fhwiesbaden.jgamp001.thello.FlexibleThelloControl;
import de.fhwiesbaden.jgamp001.thello.Spielfenster;
import de.fhwiesbaden.jgamp001.thello.ThelloGame;
import de.fhwiesbaden.jgamp001.thello.networking.Netzwerkserver;
import de.fhwiesbaden.jgamp001.thello.networking.Netzwerkspieler;
import de.flothow.jago.netobj.SpielInformation;
import de.flothow.jago.netobj.Spielertyp;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class NeuesServerSpiel
extends JFrame
implements Observer {
    private static final long serialVersionUID = 1L;
    Netzwerkserver functionalServer = Netzwerkserver.getServer();
    Netzwerkspieler functionalClient = Netzwerkspieler.getNetzwerkspieler();
    Spielfenster parent = null;
    TextArea netstat = null;
    JComboBox einsCombo;
    JComboBox zweiCombo;
    Integer serverTimeOut = 10000;
    JButton startServer;
    JButton listening;
    JButton transfer;
    JButton abort;
    JTextField feldPort = null;
    JLabel labelPort = null;
    private boolean thisPlayerWantsToStart = false;
    private Boolean clientWantsToStart = false;

    public void setPlayersReadiness(boolean arg0) {
        this.thisPlayerWantsToStart = arg0;
    }

    public NeuesServerSpiel(Spielfenster parent) {
        super("Neues Spiel leiten");
        this.observerEinrichten();
        this.parent = parent;
        this.initFrame();
        this.setVisible(true);
        this.netstat.append("Fenster geoeffnet \n");
        this.setPreferredSize(new Dimension(450, 350));
        this.pack();
    }

    private void observerEinrichten() {
        this.functionalServer.addObserver(this);
        this.functionalClient.addObserver(this);
    }

    private void initFrame() {
        JLabel netstatLabel = new JLabel("Netzwerk-Log");
        this.netstat = new TextArea("", 10, 1, 1);
        String[] options = new String[]{"Lokaler Spieler", "Lokale KI", "Netzwerkspieler", "KIoIP"};
        JLabel spielereins = new JLabel("Spieler Eins:");
        JLabel spielerzwei = new JLabel("Spieler Zwei:");
        this.labelPort = new JLabel("Port w\u00e4hlen:");
        this.feldPort = new JTextField("61541");
        this.einsCombo = new JComboBox<String>(options);
        this.zweiCombo = new JComboBox<String>(options);
        this.startServer = new JButton("Server starten");
        this.listening = new JButton("auf Spieler warten");
        this.abort = new JButton("Abbrechen");
        this.transfer = new JButton("Bereit");
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints constr = new GridBagConstraints();
        constr.fill = 2;
        constr.weightx = 50.0;
        constr.weighty = 50.0;
        this.insLayoutEinsetzen(0, 0, 10, 1, layout, constr, netstatLabel);
        this.add(netstatLabel);
        this.insLayoutEinsetzen(0, 1, 10, 7, layout, constr, this.netstat);
        this.add(this.netstat);
        this.insLayoutEinsetzen(0, 9, 2, 1, layout, constr, this.labelPort);
        this.add(this.labelPort);
        this.insLayoutEinsetzen(3, 9, 2, 1, layout, constr, this.feldPort);
        this.add(this.feldPort);
        this.insLayoutEinsetzen(0, 10, 2, 1, layout, constr, spielereins);
        this.add(spielereins);
        this.insLayoutEinsetzen(3, 10, 2, 1, layout, constr, this.einsCombo);
        this.add(this.einsCombo);
        this.insLayoutEinsetzen(0, 11, 2, 1, layout, constr, spielerzwei);
        this.add(spielerzwei);
        this.insLayoutEinsetzen(3, 11, 2, 1, layout, constr, this.zweiCombo);
        this.add(this.zweiCombo);
        this.insLayoutEinsetzen(0, 12, 2, 1, layout, constr, this.startServer);
        this.add(this.startServer);
        this.insLayoutEinsetzen(2, 12, 2, 1, layout, constr, this.listening);
        this.add(this.listening);
        this.insLayoutEinsetzen(4, 12, 2, 1, layout, constr, this.transfer);
        this.add(this.transfer);
        this.insLayoutEinsetzen(0, 13, 2, 1, layout, constr, this.abort);
        this.add(this.abort);
        this.startServer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                NeuesServerSpiel.this.startServer();
            }
        });
        this.listening.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                NeuesServerSpiel.this.listen();
            }
        });
        this.transfer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                NeuesServerSpiel.this.playerWantsToStart();
            }
        });
        this.einsCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                NeuesServerSpiel.this.setPlayersReadiness(false);
            }
        });
        this.zweiCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                NeuesServerSpiel.this.setPlayersReadiness(false);
            }
        });
        this.abort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                NeuesServerSpiel.this.pressedAbort();
            }
        });
    }

    private void insLayoutEinsetzen(int x, int y, int width, int height, GridBagLayout layout, GridBagConstraints constr, Component dings) {
        constr.gridx = x;
        constr.gridy = y;
        constr.gridwidth = width;
        constr.gridheight = height;
        layout.setConstraints(dings, constr);
    }

    private Spielertyp auswerten(JComboBox dies, boolean fuerHier) {
        Spielertyp result = null;
        switch (dies.getSelectedIndex()) {
            case 0: {
                result = fuerHier ? Spielertyp.LokalerSpieler : Spielertyp.FernerSpieler;
                break;
            }
            case 1: {
                result = fuerHier ? Spielertyp.LokalerAgent : Spielertyp.FernerAgent;
                break;
            }
            case 2: {
                result = fuerHier ? Spielertyp.FernerSpieler : Spielertyp.LokalerSpieler;
                break;
            }
            case 3: {
                result = fuerHier ? Spielertyp.FernerAgent : Spielertyp.LokalerAgent;
            }
        }
        return result;
    }

    public void listen() {
        this.listening.setEnabled(false);
        this.netstat.append("Warte auf Mispieler. Dieser Vorgang dauert an, \n- bis ein Spieler gefunden wurde \n- bis zum Timeout von " + this.serverTimeOut / 1000 + " Sekunden. \n");
        try {
            this.functionalServer.listenForClient();
        }
        catch (Exception e) {
            this.netstat.append("Exception: " + e.toString());
            return;
        }
    }

    public void startServer() {
        try {
            this.functionalServer.initServer(new Integer(this.feldPort.getText()), 10000);
            this.netstat.append("Server gestartet. Bereit auf Port: " + this.functionalServer.getServerSocket().getLocalPort() + "\n");
        }
        catch (Exception e) {
            this.netstat.append("Exception: " + e.toString() + "\n");
        }
    }

    public void update(Observable arg0, Object arg1) {
        if (arg0 == this.functionalServer) {
            if (arg1 instanceof SocketTimeoutException) {
                this.netstat.append("Timeout erreicht, kein Spieler gefunden \n");
                this.listening.setEnabled(true);
            } else if (arg1 instanceof Exception) {
                this.netstat.append("Exception: " + arg1.toString() + " \n");
                this.listening.setEnabled(true);
            } else if (arg1 instanceof Socket) {
                this.netstat.append("Mitspieler gefunden: " + ((Socket)arg1).getInetAddress() + " \n");
                this.netstat.append("Verbinde mit Mitspieler \n");
                this.connectToClient((Socket)arg1);
                this.listening.setEnabled(true);
            }
        } else if (arg0 == this.functionalClient) {
            if (arg1 instanceof Boolean) {
                this.netstat.append("Mitspieler meldet Bereitschaftsstatus: " + ((Boolean)arg1 != false ? "bereit" : "nicht bereit") + " \n");
                this.clientWantsToStart = (Boolean)arg1;
                this.startGame();
            } else if (arg1.toString().equals("EndOfListening")) {
                this.netstat.append("Gegenueber hat die Verbindung getrennt \n");
                this.abortSituation();
            }
        }
    }

    private void connectToClient(Socket arg0) {
        this.functionalClient.setSocket(arg0);
        this.netstat.append("Socket eingerichtet \n");
        try {
            this.functionalClient.setStreams();
        }
        catch (IOException e) {
            this.netstat.append("Fehler waehrend Stream-Init:" + e.toString());
        }
        this.netstat.append("Streams initialisiert \n");
        this.netstat.append("Aktiviere Lauscher...\n");
        try {
            this.functionalClient.initListener();
        }
        catch (Exception e) {
            this.netstat.append("Aktivieren der Lauscher fehlgeschlagen:" + e.toString() + "\n");
        }
        this.netstat.append("Lauscher aktiviert!\n");
    }

    public void playerWantsToStart() {
        SpielInformation result = new SpielInformation(this.auswerten(this.einsCombo, false), this.auswerten(this.zweiCombo, false));
        this.netstat.append("Spieldaten senden...");
        try {
            this.functionalClient.send(result);
        }
        catch (Exception e) {
            this.netstat.append("Fehler bei Sendeversuch: " + e.toString());
            return;
        }
        this.einsCombo.setEnabled(false);
        this.zweiCombo.setEnabled(false);
        this.netstat.append("Versand erfolgreich. Warte auf Bereitschaft des Clients");
        this.thisPlayerWantsToStart = true;
    }

    public void startGame() {
        if (this.thisPlayerWantsToStart && this.clientWantsToStart.booleanValue()) {
            try {
                this.parent.setThelloControl(new FlexibleThelloControl(new ThelloGame(), this.functionalClient, this.auswerten(this.einsCombo, true), this.auswerten(this.zweiCombo, true)));
            }
            catch (NullPointerException e) {
                System.out.println("NullPointer in Spielinformation: " + e);
            }
            this.parent.getFlexibleThelloControl().startFreigeben(true);
            this.setVisible(false);
        }
    }

    private void abortSituation() {
        this.einsCombo.setEnabled(false);
        this.zweiCombo.setEnabled(false);
        this.listening.setEnabled(false);
        this.startServer.setEnabled(false);
        this.transfer.setEnabled(false);
        this.netstat.append("\nBitte dieses Fenster schlie\u00dfen\n");
    }

    private void pressedAbort() {
        this.abortWindow();
    }

    private void abortWindow() {
        this.functionalClient.reset();
        try {
            this.functionalServer.closeServer();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setVisible(false);
    }
}

