/*
 * Decompiled with CFR 0.152.
 */
package de.fhwiesbaden.jgamp001.thello.networking.gui;

import de.fhwiesbaden.jgamp001.thello.FlexibleThelloControl;
import de.fhwiesbaden.jgamp001.thello.Spielfenster;
import de.fhwiesbaden.jgamp001.thello.ThelloGame;
import de.fhwiesbaden.jgamp001.thello.networking.Netzwerkspieler;
import de.flothow.jago.netobj.SpielInformation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class SpielTeilnehmen
extends JFrame
implements Observer {
    private static final long serialVersionUID = 1L;
    public JTextField ipFeld = null;
    public JTextField port = null;
    public TextArea netstat = null;
    private JLabel netstatLabel = null;
    private JLabel labelDatenEmpfang = null;
    private JLabel labelSpielerEins = null;
    private JLabel labelSpielerZwei = null;
    private JTextArea areaSpielerEins = null;
    private JTextArea areaSpielerZwei = null;
    private JButton connect;
    private JButton abort;
    private JButton bereit;
    Netzwerkspieler functionalClient = Netzwerkspieler.getNetzwerkspieler();
    public Spielfenster parent = null;
    private boolean serverIstBereit = false;
    private boolean infoErhalten = false;

    public SpielTeilnehmen(Spielfenster parent) {
        this.parent = parent;
        this.initDesign();
        this.setVisible(true);
        this.setPreferredSize(new Dimension(450, 350));
        this.pack();
    }

    private void initDesign() {
        this.netstatLabel = new JLabel("Netzwerk-Log");
        this.netstat = new TextArea("", 10, 1, 1);
        this.netstat.setEditable(false);
        this.ipFeld = new JTextField("localhost");
        this.port = new JTextField("61541");
        this.connect = new JButton("Verbinden");
        this.abort = new JButton("Abbrechen");
        this.bereit = new JButton("Bereit");
        this.labelDatenEmpfang = new JLabel("Empfangene Spielinformation:");
        this.labelSpielerEins = new JLabel("Spieler Eins: ");
        this.labelSpielerZwei = new JLabel("Spieler Zwei: ");
        this.areaSpielerEins = new JTextArea("-nix-");
        this.areaSpielerZwei = new JTextArea("-nix-");
        this.areaSpielerEins.setEditable(false);
        this.areaSpielerZwei.setEditable(false);
        this.aktionenSetzen();
        this.objekteInsLayout();
    }

    private void objekteInsLayout() {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints constr = new GridBagConstraints();
        constr.fill = 2;
        constr.weightx = 50.0;
        constr.weighty = 50.0;
        this.insLayoutEinsetzen(0, 0, 10, 1, layout, constr, this.netstatLabel);
        this.add(this.netstatLabel);
        this.insLayoutEinsetzen(0, 1, 10, 7, layout, constr, this.netstat);
        this.add(this.netstat);
        this.insLayoutEinsetzen(0, 10, 2, 1, layout, constr, this.labelDatenEmpfang);
        this.add(this.labelDatenEmpfang);
        this.insLayoutEinsetzen(0, 12, 4, 1, layout, constr, this.labelSpielerEins);
        this.add(this.labelSpielerEins);
        this.insLayoutEinsetzen(3, 12, 4, 1, layout, constr, this.areaSpielerEins);
        this.add(this.areaSpielerEins);
        this.insLayoutEinsetzen(0, 14, 2, 1, layout, constr, this.labelSpielerZwei);
        this.add(this.labelSpielerZwei);
        this.insLayoutEinsetzen(3, 14, 4, 1, layout, constr, this.areaSpielerZwei);
        this.add(this.areaSpielerZwei);
        this.insLayoutEinsetzen(0, 16, 2, 1, layout, constr, this.ipFeld);
        this.add(this.ipFeld);
        this.insLayoutEinsetzen(3, 16, 2, 1, layout, constr, this.port);
        this.add(this.port);
        this.insLayoutEinsetzen(0, 17, 2, 1, layout, constr, this.connect);
        this.add(this.connect);
        this.insLayoutEinsetzen(3, 17, 2, 1, layout, constr, this.abort);
        this.add(this.abort);
        this.insLayoutEinsetzen(0, 18, 2, 1, layout, constr, this.bereit);
        this.add(this.bereit);
    }

    private void insLayoutEinsetzen(int x, int y, int width, int height, GridBagLayout layout, GridBagConstraints constr, Component dings) {
        constr.gridx = x;
        constr.gridy = y;
        constr.gridwidth = width;
        constr.gridheight = height;
        layout.setConstraints(dings, constr);
    }

    private void aktionenSetzen() {
        this.connect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SpielTeilnehmen.this.pressedConnect();
            }
        });
        this.abort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SpielTeilnehmen.this.pressedAbort();
            }
        });
        this.bereit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SpielTeilnehmen.this.pressedBereit();
            }
        });
    }

    public void update(Observable arg0, Object arg1) {
        this.netstat.append("Catch Action \n");
        if (arg0 == this.functionalClient) {
            if (arg1 instanceof SpielInformation) {
                this.handleIncomingInfo((SpielInformation)arg1);
            } else if (arg1.toString().equals("EndOfListening")) {
                this.netstat.append("Gegenueber hat die Verbindung getrennt \n");
                this.abortSituation();
            }
        }
    }

    private void handleIncomingInfo(SpielInformation info) {
        this.netstat.append("Neue Spielinformationen erhalten \n");
        this.areaSpielerEins.setText(info.getSpielerEins().toString());
        this.areaSpielerZwei.setText(info.getSpielerZwei().toString());
        this.infoErhalten = true;
        this.serverIstBereit = true;
    }

    public void pressedBereit() {
        if (this.infoErhalten && this.serverIstBereit) {
            this.netstat.append("Versende Akzeptanz der Spielinformation \n");
            try {
                this.functionalClient.send(true);
            }
            catch (Exception e) {
                this.netstat.append("Versand der Bereitschaftsnachricht gescheitert. \n" + e.toString());
            }
            this.netstat.append("Erfolgreich \n");
            SpielInformation result = this.functionalClient.getLastReceivedInfo();
            FlexibleThelloControl neuesThello = new FlexibleThelloControl(new ThelloGame(), this.functionalClient, result.getSpielerEins(), result.getSpielerZwei());
            this.parent.setThelloControl(neuesThello);
            this.startGame();
        }
    }

    public void pressedConnect() {
        this.netstat.append("Verbindungsversuch zu: " + this.ipFeld.getText() + " an Port: " + new Integer(this.port.getText()) + "\n");
        if (this.sicherheitsAbfrage("Dieser Verbindungsversuch h\u00e4lt das Programm an \n- bis ein Spieler gefunden wurde oder \n- bis der Timeout von 10 Sekunden erreicht ist. \nFortsetzen?")) {
            this.doConnect();
        }
    }

    private boolean sicherheitsAbfrage(String text) {
        return JOptionPane.showConfirmDialog(this, text, "Hinweis", 0) == 0;
    }

    public void pressedAbort() {
        this.abortWindow();
    }

    private void doConnect() {
        try {
            this.functionalClient.setSocket(this.ipFeld.getText(), new Integer(this.port.getText()));
            this.netstat.append("Verbindung hergestellt \n");
            System.out.println("Streams setzen");
            this.functionalClient.setStreams();
            System.out.println("Streams setzen beendet");
            this.netstat.append("Streams initialisiert \n");
        }
        catch (Exception e) {
            this.netstat.append("Verbindungsfehler: " + e.toString() + "\n");
            this.netstat.append("Setze alle Verbindungsversuche zurueck \n");
            try {
                this.functionalClient.unsetSocket();
                this.functionalClient.unsetStreams();
            }
            catch (IOException e1) {
                this.netstat.append(e1.toString());
            }
            return;
        }
        try {
            this.netstat.append("Aktiviere Lauscher...\n");
            System.out.println("Aktiviere Lauscher...");
            this.functionalClient.initListener();
        }
        catch (Exception e) {
            this.netstat.append("Aktivieren der Lauscher fehlgeschlagen:" + e.toString() + "\n");
        }
        this.netstat.append("Lauscher aktiviert! \n");
        this.functionalClient.addObserver(this);
        this.netstat.append("Warte auf SpielInformationen \n");
    }

    public void startGame() {
        this.parent.getFlexibleThelloControl().startFreigeben(true);
        this.setVisible(false);
    }

    private void abortSituation() {
        this.connect.setEnabled(false);
        this.bereit.setEnabled(false);
        this.netstat.append("\nBitte dieses Fenster schlie\u00dfen\n");
    }

    private void abortWindow() {
        this.functionalClient.reset();
        this.setVisible(false);
    }
}

